"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.executeWatch = executeWatch;
exports.executeWatchRoute = executeWatchRoute;
var _configSchema = require("@kbn/config-schema");
var _errors = require("../../lib/errors");
var _constants = require("../../../../../common/signals/constants");
/*
 *    Copyright 2020 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

function executeWatch({
  clusterClient,
  logger
}) {
  return async function (context, request, response) {
    try {
      const {
        body: {
          watch,
          simulate = false,
          skipActions = true,
          showAllRuntimeAttributes = true
        },
        headers: {
          sgtenant = _constants.NO_MULTITENANCY_TENANT
        }
      } = request;
      const path = `/_signals/watch/${encodeURIComponent(sgtenant)}/_execute`;
      const resp = await clusterClient.asScoped(request).asCurrentUser.transport.request({
        method: 'post',
        path,
        body: {
          watch,
          simulate,
          skip_actions: skipActions,
          show_all_runtime_attributes: showAllRuntimeAttributes
        }
      });
      return response.ok({
        body: {
          ok: true,
          resp
        }
      });
    } catch (err) {
      logger.error(`executeWatch: ${err.stack}`);
      return response.customError((0, _errors.serverError)(err));
    }
  };
}
function executeWatchRoute({
  router,
  clusterClient,
  logger
}) {
  router.post({
    path: `${_constants.ROUTE_PATH.WATCH}/_execute`,
    validate: {
      body: _configSchema.schema.object({
        watch: _configSchema.schema.object({
          checks: _configSchema.schema.arrayOf(_configSchema.schema.object({}, {
            unknowns: 'allow'
          })),
          actions: _configSchema.schema.arrayOf(_configSchema.schema.object({}, {
            unknowns: 'allow'
          })),
          trigger: _configSchema.schema.object({}, {
            unknowns: 'allow'
          }),
          _meta: _configSchema.schema.object({}, {
            unknowns: 'allow'
          })
        }, {
          unknowns: 'allow'
        }),
        simulate: _configSchema.schema.boolean({
          defaultValue: false
        }),
        skipActions: _configSchema.schema.boolean({
          defaultValue: true
        }),
        showAllRuntimeAttributes: _configSchema.schema.boolean({
          defaultValue: true
        })
      })
    }
  }, executeWatch({
    clusterClient,
    logger
  }));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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